<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Takvim";
    include 'partials/title-meta.php'; ?>

    <!-- Plugin css -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/jquery-migrate-3.3.2.min.js"></script>
    <link rel="stylesheet" type="text/css" href="path/to/dhtmlxScheduler/codebase/dhtmlxscheduler.css">
<script src="path/to/dhtmlxScheduler/codebase/dhtmlxscheduler.js"></script>

    <link href="assets/libs/fullcalendar/main.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css">
    <?php include 'partials/head-css.php'; ?>
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0, 0, 0);
            background-color: rgba(0, 0, 0, 0.4);
            padding-top: 60px;
        }

        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover {
            color: black;
        }
    </style>
    <script src='assets/libs/takvim/dist/index.global.js'></script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    var today = new Date();
    var calendar = dhtmlXScheduler.init('scheduler_here', today, 'week'); // DHTMLX Scheduler'ı başlatın
    var modal = document.getElementById('eventModal');
    var closeBtn = document.querySelector('.close');

    // Diğer gerekli değişkenleri tanımlayın

    function formatDateForScheduler(date) {
        // FullCalendar'dan DHTMLX Scheduler'a tarih formatını dönüştürme
        var eventDate = new Date(date);
        return eventDate;
    }

    window.addEvent = function(start, end) {
        // Etkinlik eklemek için DHTMLX Scheduler kullanma
        var titleInput = document.getElementById('eventTitle');
        var title = titleInput.value;
        var descInput = document.getElementById('description');
        var desc = descInput.value;
        // Diğer gerekli bilgileri alın

        if (!title) {
            alert('Randevu adı boş bırakılamaz.');
            return;
        }

        // Etkinlik nesnesini oluşturun
        var eventData = {
            start_date: formatDateForScheduler(start),
            end_date: formatDateForScheduler(end),
            text: title,
            description: desc,
            // Diğer gerekli bilgileri ekleyin
        };

        // DHTMLX Scheduler API'sini kullanarak etkinliği ekleme
        calendar.addEvent(eventData);

        // Diğer işlemleri burada devam ettirin
    };

    // Diğer kodunuzu DHTMLX Scheduler ile uyumlu hale getirin

});
</script>






</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Takvim";
    include 'partials/menu.php';  ?>

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="row">


                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">

                                        <div id="calendar"></div>
                                        <div id="eventModal" class="modal">
                                            <div class="modal-content">
                                                <span class="close" onclick="closeModal()">&times;</span>
                                                <div id="eventDetails"></div>
                                            </div>
                                        </div>

                                    </div> <!-- end card body-->
                                </div> <!-- end card -->
                            </div> <!-- end col -->

                        </div> <!-- end row -->


                        <!-- Add New Event MODAL -->
                        <div class="modal fade" id="event-modal" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header py-3 px-4 border-bottom-0 d-block">
                                        <button type="button" class="btn-close float-end" data-bs-dismiss="modal" aria-label="Close"></button>
                                        <h5 class="modal-title" id="modal-title">Event</h5>
                                    </div>
                                    <div class="modal-body px-4 pb-4 pt-0">
                                        <form class="needs-validation" name="event-form" id="form-event" novalidate>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label">Event Name</label>
                                                        <input class="form-control" placeholder="Insert Event Name" type="text" name="title" id="event-title" required />
                                                        <div class="invalid-feedback">Please provide a valid event name</div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label">Category</label>
                                                        <select class="form-select" name="category" id="event-category" required>
                                                            <option value="bg-danger" selected>Danger</option>
                                                            <option value="bg-success">Success</option>
                                                            <option value="bg-primary">Primary</option>
                                                            <option value="bg-info">Info</option>
                                                            <option value="bg-dark">Dark</option>
                                                            <option value="bg-warning">Warning</option>
                                                        </select>
                                                        <div class="invalid-feedback">Please select a valid event category</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-2">
                                                <div class="col-md-6 col-4">
                                                    <button type="button" class="btn btn-danger" id="btn-delete-event">Delete</button>
                                                </div>
                                                <div class="col-md-6 col-8 text-end">
                                                    <button type="button" class="btn btn-light me-1" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-success" id="btn-save-event">Save</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div> <!-- end modal-content-->
                            </div> <!-- end modal dialog-->
                        </div>
                        <!-- end modal-->
                    </div>
                    <!-- end col-12 -->
                </div> <!-- end row -->

            </div> <!-- container -->

        </div> <!-- content -->

        <?php include 'partials/footer.php'; ?>

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/right-sidebar.php'; ?>

<?php include 'partials/footer-scripts.php'; ?>
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<!-- plugin js -->
<script src="assets/libs/moment/min/moment.min.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>

</html>