<?php
include 'netting/baglan.php';
$data = array();

// Oda id'sini alın
$oda_id = isset($_POST['id']) ? $_POST['id'] : null;

if ($oda_id !== null) {
    // Dosya yükleme işlemini gerçekleştirin
    if(isset($_FILES['upload']['name'])) {
        $file_name = $_FILES['upload']['name'];
        $file_path = '../gorsel/odalar/' . $file_name;
        $file_extension = strtolower(pathinfo($file_path, PATHINFO_EXTENSION));

        if($file_extension == 'jpg' || $file_extension == 'jpeg' || $file_extension == 'png') {
            if(move_uploaded_file($_FILES['upload']['tmp_name'], $file_path)) {

                // Başarı durumunda dosya bilgilerini döndür
                $data['file'] = $file_name;
                $data['url'] = $file_path;
                $data['uploaded'] = 1;

                // Hedef görseli yükle
                if($file_extension == 'jpg' || $file_extension == 'jpeg') {
                    $hedefGorsel = imagecreatefromjpeg($file_path);
                } elseif($file_extension == 'png') {
                    $hedefGorsel = imagecreatefrompng($file_path);
                }

                // Filigran PNG dosyasını aç
                $damga = imagecreatefrompng('../gorsel/varsayilan/logo2.png');

                // Resim boyutlarını al
                $hedefGenislik = imagesx($hedefGorsel);
                $hedefYukseklik = imagesy($hedefGorsel);
                $damgaGenislik = imagesx($damga);
                $damgaYukseklik = imagesy($damga);

                // Filigranın konumunu belirle (orta nokta)
                $damgaX = ($hedefGenislik / 2) - ($damgaGenislik / 2); // Ortada olacak şekilde X koordinatı
                $damgaY = ($hedefYukseklik / 2) - ($damgaYukseklik / 2); // Ortada olacak şekilde Y koordinatı

                // Filigranı ana görsele kopyala
                imagecopy($hedefGorsel, $damga, $damgaX, $damgaY, 0, 0, $damgaGenislik, $damgaYukseklik);

                // Sonuç resmini kaydet
                if($file_extension == 'jpg' || $file_extension == 'jpeg') {
                    imagejpeg($hedefGorsel, $file_path, 100); // 100 kalite ile kaydet
                } elseif($file_extension == 'png') {
                    imagepng($hedefGorsel, $file_path);
                }

                // Belleği temizle
                imagedestroy($hedefGorsel);
                imagedestroy($damga);

                // Veritabanına kaydet
                $kaydet = $db->prepare("INSERT INTO odalar_gorsel SET
                    oda=:oda,
                    url=:url
                ");
                $insert = $kaydet->execute(array(
                    'oda' => $oda_id,
                    'url' => $file_path
                ));

            } else {
                $data['uploaded'] = 0;
                $data['error']['message'] = 'Error! File not uploaded';
            }
        } else {
            $data['uploaded'] = 0;
            $data['error']['message'] = 'Invalid extension';
        }
    }
} else {
    $data['uploaded'] = 0;
    $data['error']['message'] = 'Oda ID not provided';
}

// Sonucu JSON olarak döndür
echo json_encode($data);
?>
