<?php
session_start(); // Oturum yönetimi için

// Veritabanı bağlantısı
include 'baglan.php'; // baglan.php dosyasını dahil et

// Yetkilendirme kontrolü (örnek)
if (!isset($_SESSION['kullanici_mail'])) {
    echo json_encode(['error' => 'Yetkisiz erişim']);
    exit;
}

// Gelen istek tipine göre işlem yap
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];

        switch ($action) {
            case 'getEvents':
                $roomId = isset($_POST['room_id']) ? intval($_POST['room_id']) : 0; // Oda ID'sini al
                getEvents($db, $roomId);
                break;

            case 'addEvent':
                addEvent($db);
                break;

            case 'updateEvent':
                updateEvent($db);
                break;

            case 'deleteEvent':
                deleteEvent($db);
                break;

            case 'checkEventConflict':
                checkEventConflict($db);
                break;

            case 'checkEventConflictnew':
                checkEventConflictnew($db);
                break;

            default:
                echo json_encode(['error' => 'Geçersiz işlem']);
        }
    }
}

// Etkinlikleri getirme fonksiyonu
function getEvents($db, $roomId) {
    $stmt = $db->prepare("SELECT id, title, start, end, backgroundColor, borderColor FROM odalar_takvim WHERE oda = ?");
    $stmt->execute([$roomId]);
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    header('Content-Type: application/json');
    echo json_encode($events);
}

// Etkinlik ekleme fonksiyonu
function addEvent($db) {
    // Gelen POST verilerini al
    $title = htmlspecialchars($_POST['title']);
    $oda = htmlspecialchars($_POST['oda']);
    $start = htmlspecialchars($_POST['start']);
    $end = htmlspecialchars($_POST['end']);

    // Veritabanına etkinliği ekle
    $stmt = $db->prepare("INSERT INTO odalar_takvim (title, oda, start, end, backgroundColor, borderColor) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$title, $oda, $start, $end, "#ff0000", "#ff0000"]);

    echo json_encode(['status' => 'success']);
}

// Etkinlik güncelleme fonksiyonu
function updateEvent($db) {
    $id = htmlspecialchars($_POST['id']);
    $start = htmlspecialchars($_POST['start']);
    $end = htmlspecialchars($_POST['end']);

    // Etkinliği güncelle
    $stmt = $db->prepare("UPDATE odalar_takvim SET start = ?, end = ?, backgroundColor = ?, borderColor = ? WHERE id = ?");
    $stmt->execute([$start, $end, "#ff0000", "#ff0000", $id]);

    echo json_encode(['status' => 'success']);
}

// Etkinlik silme fonksiyonu
function deleteEvent($db) {
    $id = htmlspecialchars($_POST['id']);

    // Etkinliği sil
    $stmt = $db->prepare("DELETE FROM odalar_takvim WHERE id = ?");
    $stmt->execute([$id]);

    echo json_encode(['status' => 'success']);
}

// Oda ve tarih bazlı çakışma kontrolü
function checkEventConflict($db) {
    $id = htmlspecialchars($_POST['id']);
    $roomId = htmlspecialchars($_POST['room_id']);
    $start = htmlspecialchars($_POST['start']);
    $end = htmlspecialchars($_POST['end']);
    
    // Verilen oda ID'sine ve tarihe göre başka bir etkinlik olup olmadığını kontrol et
    $stmt = $db->prepare("
        SELECT COUNT(*) as count 
        FROM odalar_takvim 
        WHERE id != $id and oda = ? AND (
            ('$start' BETWEEN start AND end) OR  -- Yeni etkinliğin başlangıç tarihi mevcut etkinlikler arasında mı?
            ('$end' BETWEEN start AND end) OR      -- Yeni etkinliğin bitiş tarihi mevcut etkinlikler arasında mı?
            (start <= '$end' AND end >= '$start') -- Yeni etkinliğin tarih aralığı mevcut etkinliklerle çakışıyor mu?
        )
    ");

    // Sorguyu çalıştır
    $stmt->execute([$roomId]); // Oda ID'sini kullan
    $event = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($event['count'] > 0) {
        echo json_encode(['conflict' => true]); // Çakışma varsa
    } else {
        echo json_encode(['conflict' => false]); // Çakışma yoksa
    }
}


function checkEventConflictnew($db) {
    $roomId = htmlspecialchars($_POST['room_id']);
    $start = htmlspecialchars($_POST['start']);
    $end = htmlspecialchars($_POST['end']);
    
    // Verilen oda ID'sine ve tarihe göre başka bir etkinlik olup olmadığını kontrol et
    $stmt = $db->prepare("
        SELECT COUNT(*) as count 
        FROM odalar_takvim 
        WHERE oda = ? AND (
            ('$start' BETWEEN start AND end) OR  -- Yeni etkinliğin başlangıç tarihi mevcut etkinlikler arasında mı?
            ('$end' BETWEEN start AND end) OR      -- Yeni etkinliğin bitiş tarihi mevcut etkinlikler arasında mı?
            (start <= '$end' AND end >= '$start') -- Yeni etkinliğin tarih aralığı mevcut etkinliklerle çakışıyor mu?
        )
    ");

    // Sorguyu çalıştır
    $stmt->execute([$roomId]); // Oda ID'sini kullan
    $event = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($event['count'] > 0) {
        echo json_encode(['conflict' => true]); // Çakışma varsa
    } else {
        echo json_encode(['conflict' => false]); // Çakışma yoksa
    }
}


?>
