<?php
// ajax.php

// Veritabanı bağlantısı ve etkinlikleri getirme işlemleri
require_once("baglan.php"); // Veritabanı bağlantınızı sağlayan dosya

// Tüm etkinlikleri getir
$etkinlikSorgu = $db->prepare("SELECT id, title, start, end, description, plaka, musteri FROM randevu ORDER BY id ASC");
$etkinlikSorgu->execute();

$etkinlikler = array();
while ($etkinlik = $etkinlikSorgu->fetch(PDO::FETCH_ASSOC)) {
    // Müşteri bilgilerini çekmek için gerekli sorguyu buraya ekleyin
    $musteriSorgu = $db->prepare("SELECT name FROM musteriler WHERE id = :musteriId");
    $musteriSorgu->bindParam(':musteriId', $etkinlik['musteri'], PDO::PARAM_INT);
    $musteriSorgu->execute();
    $musteri = $musteriSorgu->fetch(PDO::FETCH_ASSOC);

    // Eğer müşteri bulunduysa, müşteri bilgilerini etkinlik verisine ekleyin
    if ($musteri) {
        $etkinlik['musteri'] = $musteri['name'];
        $etkinlik['plaka'] = $etkinlik['plaka']; // Buraya plaka sütununu eklemek gerekirse ekle
        // Diğer müşteri bilgilerini eklemek için gerekli sütunları buraya ekleyin
    }

    $etkinlikler[] = $etkinlik;
}

// JSON formatında çıktı ver
header("Content-Type: application/json");
echo json_encode($etkinlikler);
?>