<?php 

include 'sayfalar/header.php'; ?>


<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Yönetim Paneli";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">


    <?php $pagetitle = "Yönetim Paneli"; include 'partials/menu.php';  ?>


    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">
<?php if ($kullanicicek['yetki']>=2) {
    $odasor=$db->prepare("SELECT * FROM odalar where isletme=:isletme and durum='1'");
    $odasor->execute(array(
        'isletme' => $isletme['id']
    ));
    
    $odasay = $odasor->rowCount();

    $odalar = array();
    $odasor = $db->prepare("SELECT id FROM odalar WHERE isletme = :isletme_id");
    $odasor->execute(['isletme_id' => $isletme['id']]);
    while ($oda = $odasor->fetch(PDO::FETCH_ASSOC)) {
        $odalar[] = $oda['id'];
    }
    
    // Bugünkü tarihi al
    $bugun = date('Y-m-d');
    
    // Her bir oda için günlük görüntülenme sayısını hesapla
    $gunluk_goruntulenmeler = array();
    foreach ($odalar as $oda_id) {
        $stmt = $db->prepare("SELECT COUNT(*) FROM odalar_goruntuleme WHERE oda_id = :oda_id");
        $stmt->execute(['oda_id' => $oda_id]);
        $gunluk_goruntulenme = $stmt->fetchColumn();
        $gunluk_goruntulenmeler[$oda_id] = $gunluk_goruntulenme;
    }
    
    // Günlük görüntülenme sayılarını ekrana yazdırma (örnek)
    foreach ($gunluk_goruntulenmeler as $oda_id => $sayi) {
        $toplamgoruntulenme+=$sayi;
    }


    $rezervasyontalep=$db->prepare("SELECT * FROM rezervasyon where isletme=:isletme and durum='0'");
    $rezervasyontalep->execute(array(
        'isletme' => $isletme['id']
    ));
    
    $rezervasyontalepsay = $rezervasyontalep->rowCount();
    ?>
                <div class="row">


                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">Listelenen Odalar</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2">
                                        <h2 class="fw-normal mb-1"> <?php echo $odasay; ?> </h2>
                                        <p class="text-muted mb-3">oda</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">Rezervasyon Talebi</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <span class="badge bg-<?php if ($rezervasyontalepsay>0) { echo 'warning'; } else { echo 'success'; } ?> rounded-pill float-start mt-3"><i class="<?php if ($rezervasyontalepsay>0) { echo 'fa fa-exclamation-triangle'; } else { echo 'fa fa-check'; }?>"></i> </span>
                                        <h2 class="fw-normal mb-1"> <?php echo $rezervasyontalepsay; ?> </h2>
                                        <p class="text-muted mb-3">cevaplanmamış</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">İşletmenizin Gösterimi</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <!--<span class="badge bg-success rounded-pill float-start mt-3">32% <i class="mdi mdi-trending-up"></i> </span>-->
                                        <h2 class="fw-normal mb-1"> <?php echo $toplamgoruntulenme; ?> </h2>
                                        <p class="text-muted mb-3">tüm zamanlar</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">Kalan Bakiye</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <span class="badge bg-success rounded-pill float-start mt-3">32% <i class="mdi mdi-trending-up"></i> </span>
                                        <h2 class="fw-normal mb-1"> 255.01 </h2>
                                        <p class="text-muted mb-3">₺</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="dropdown float-end">
                                    <a href="rezervasyonlar" class="arrow-none card-drop"  aria-expanded="false">
                                        <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>

                                <h4 class="header-title mt-0 mb-3">Son Rezervasyon Talepleri</h4>

                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                    <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>İsim</th>
                                                <th width="20px">Durum</th>
                                                <th>İşlem</th>
                                            </tr>
                                            </thead>


                                            <tbody>
                                            <?php

                                            $rezervesor=$db->prepare("SELECT * FROM rezervasyon where isletme=:isletme");
                                            $rezervesor->execute(array(
                                                'isletme' => $isletme['id']
                                            ));

                                            $say=0;
                                            while($rezerve=$rezervesor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                                ?>
                                                <tr>
                                                    <td><a href="rezervasyon?goruntule=<?php echo $rezerve['id']; ?>"><?php echo $say; ?></a></td>
                                                    <td><a href="rezervasyon?goruntule=<?php echo $rezerve['id']; ?>"><?php echo $rezerve['isim']; ?></a></td>
                                                    <td class="text-center"><a href="rezervasyon?goruntule=<?php echo $rezerve['id']; ?>"><?php echo ($rezerve['durum'] == 1) ? '<span class="badge bg-success">GÖRÜŞÜLDÜ</span>' : '<span class="badge bg-danger">YENİ REZERVASYON</span>'; ?></a></td>
                                                    <td align="center">
                                                         <a href="rezervasyon?goruntule=<?php echo $rezerve['id']; ?>"><i class="fa fa-eye fa-4"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                         <!--<a href="netting/islem.php?odasil=sil&id=<?php //echo $rezerve['id']; ?>" data-id="<?php //echo $mustericek['id']; ?>"><i class="fa fa-trash fa-4"></i></a>-->
                                                </td>
                                                
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div><!-- end col -->

                </div>
                <!-- end row -->

<?php } else { 

    
$basvurusor=$db->prepare("SELECT * FROM isletmeler_basvuru where kullanici=:kullanici and (durum=:durum1 or durum=:durum2 or durum=:durum3)");
$basvurusor->execute(array(
    'kullanici' => $kullanicicek['id'],
    'durum1' => 1,
    'durum2' => 2,
    'durum3' => 3
    ));

$say=$basvurusor->rowcount();
$basvurucek=$basvurusor->fetch(PDO::FETCH_ASSOC);
    if ($say>0) {
    ?>
    <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body project-box">
                                <div class="badge bg-<?php 
                                if ($basvurucek['durum']==1) { echo "primary"; } 
                                elseif ($basvurucek['durum']==2) { echo "warning"; } 
                                elseif ($basvurucek['durum']==3) { echo "success"; } 
                                elseif ($basvurucek['durum']==0) { echo "danger"; }  ?> float-end">
                                <?php 
                                if ($basvurucek['durum']==1) { echo "Başvuru gönderildi."; } 
                                elseif ($basvurucek['durum']==2) { echo "Başvuru incelemede"; } 
                                elseif ($basvurucek['durum']==3) { echo "Başvuru Onaylandı"; } 
                                elseif ($basvurucek['durum']==0) { echo "Reddedildi"; }  ?>
                                </div>
                                <h4 class="mt-0"><a href="" class="text-dark"><?php echo $basvurucek['isim']; ?></a></h4>
<?php

$ilsor=$db->prepare("SELECT * FROM il where id=:id");
$ilsor->execute(array(
    'id' => $basvurucek['il']
    ));

$il=$ilsor->fetch(PDO::FETCH_ASSOC);

$ilcesor=$db->prepare("SELECT * FROM ilce where ilce_key=:ilce_key");
$ilcesor->execute(array(
    'ilce_key' => $basvurucek['ilce']
    ));

$ilce=$ilcesor->fetch(PDO::FETCH_ASSOC);

?>
                                <p class="text-success text-uppercase font-13"><?php echo $ilce['isim'] . " / " . $il['isim']; ?></p>
                                <p class="text-muted font-13"><?php echo $basvurucek['adres']; ?>
                                </p>
                                <?php
	
	
	
	function zamanonce($tarih) {
		
	   $cevrilenzaman = strtotime($tarih);	
	   //Zamanı strtotime fonksiyonu ile unix zaman damgasını alıyoruz. Yani Zamanı sayısal olarak alıyoruz.
	   
	   $zamanismi= array("Saniye", "Dakika", "Saat", "Gün", "Ay", "Yıl");
	   $sure= array("60","60","24","30","12","10");

	   $simdikizaman = time();
	   //zamanı unix zaman damgası olarak alıyoruz.
	   
	   if($simdikizaman >= $cevrilenzaman) 
	   {
			$fark     = time()- $cevrilenzaman;
			for($i = 0; $fark >= $sure[$i] && $i < count($sure)-1; $i++) 
			{
			$fark = $fark / $sure[$i];
			}

			$fark = round($fark);
			//fark değişkenini yuvarlıyor
			
			return $fark . " " . $zamanismi[$i] . " Önce";
	   }
	}
	
?>
                                <ul class="list-inline">
                                    <li class="list-inline-item me-4">
                                        <h4 class="mb-0">Başvuru Tarihi</h4>
                                        <p class="text-muted"><span title="<?php echo $basvurucek['tarih']; ?>" tabindex="0" data-plugin="tippy" data-tippy-followCursor="true" data-tippy-arrow="true" data-tippy-animation="fade"><?php echo zamanonce($basvurucek['tarih']); ?></span></p>
                                    </li>
                                </ul>
                                <div class="row">
                                    <div class="col-md-8">
                                        <h5>Başvuru Durumu <span class="text-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> float-end"><?php if ($basvurucek['durum']==1) { echo "1/3"; } elseif ($basvurucek['durum']==2) { echo "2/3"; } elseif ($basvurucek['durum']==3) { echo "✓"; } else { echo "×"; } ?></span></h5>
                                        <div class="progress progress-bar-alt-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> progress-sm">
                                            <div class="progress-bar bg-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> progress-animated wow animated animated"
                                                role="progressbar" aria-valuenow="1" aria-valuemin="0" aria-valuemax="100"
                                                style="width: <?php if ($basvurucek['durum']==1) { echo "33"; } elseif ($basvurucek['durum']==2) { echo "67"; } elseif ($basvurucek['durum']==3) { echo "100"; } else { echo "100"; } ?>%; visibility: visible; animation-name: animationProgress;">
                                            </div><!-- /.progress-bar .progress-bar-danger -->
                                        </div><!-- /.progress .no-rounded -->
                                    </div>
                                    <?php if ($basvurucek['durum']==0) { ?>
                                    <div class="col-md-4 float-end">
                                        <a href="basvuru-duzenle.php?duzenle=<?php echo $basvurucek['id']; ?>"><button type="button" class="btn btn-warning waves-effect waves-light float-end" title="<?php echo $basvurucek['tarih']; ?>" tabindex="0" data-plugin="tippy" data-tippy-followCursor="true" data-tippy-arrow="true" data-tippy-animation="fade">
                                            <span class="btn-label"><i class="mdi mdi-square-edit-outline"></i></span>Düzenle
                                        </button></a>
                                    </div>
                                    <?php } ?>
                                    <div class="col-md-4 float-end">
                                        <a href="basvuru.php?goruntule=<?php echo $basvurucek['id']; ?>"><button type="button" class="btn btn-primary waves-effect waves-light float-end" >
                                            <span class="btn-label"><i class="mdi mdi-eye"></i></span>Görüntüle
                                        </button></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div><!-- end col-->
    <?php }
else { header('Location: isletme-basvuru'); } } ?>
            </div> <!-- container-fluid -->

        </div> <!-- content -->

        <?php include 'partials/footer.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/right-sidebar.php'; ?>

<?php include 'partials/footer-scripts.php'; ?>

<!-- knob plugin -->
<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>
<!--Morris Chart-->
<script src="assets/libs/morris.js06/morris.min.js"></script>
<script src="assets/libs/raphael/raphael.min.js"></script>

<!-- Dashboar init js-->
<script src="assets/js/pages/dashboard.init.js"></script>

<!-- App js-->
<script src="assets/js/app.min.js"></script>

</body>

</html>