<?php include 'sayfalar/header.php'; ?>
<?php

if ($kullanicicek['yetki'] < 5) {
    $basvurusor = $db->prepare("SELECT * FROM isletmeler_basvuru where kullanici=:kullanici");
    $basvurusor->execute(array(
        'kullanici' => $kullanicicek['id']
    ));

    $say = $basvurusor->rowcount();
    $basvurucek = $basvurusor->fetch(PDO::FETCH_ASSOC);
    if ($say > 0) {
        if ($basvurucek['durum'] == 0) {
        } else {
            header("Location:index");
        }
    } else {
    }
}

?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "İşletme Başvuru";
    include 'partials/title-meta.php'; ?>
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/google-libphonenumber/7.2.9/libphonenumber.min.js"></script>
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />
    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "İşletme Başvuru";
    include 'partials/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="header-title">İşletme Başvurusu</h4>
                                <p class="text-muted font-13">Kullanıcı bilgilerinizi ve işletme bilgilerinizi tamamlayarak işletme hesabınızı onaylatabilirsiniz.</p>

                                <form id="myForm">
                                    <div class="row">
                                        <span class="text-center" style="color: black">
                                            <h3>Kullanıcı Bilgileri</h3>
                                        </span>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">Ad</label>
                                            <input type="text" id="simpleinput" class="form-control-plaintext" readonly required value="<?php echo $kullanicicek['ad']; ?>">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">Soyad</label>
                                            <input type="text" id="simpleinput" class="form-control-plaintext" readonly required value="<?php echo $kullanicicek['soyad']; ?>">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">E-Posta</label>
                                            <input type="email" id="simpleinput" class="form-control-plaintext" readonly required value="<?php echo $kullanicicek['email']; ?>">
                                        </div>
                                        <?php if (empty($kullanicicek['gsm'])) { ?>
                                            <div class="col-md-3">
                                                <label for="simpleinput" class="form-label">Telefon <span id="result" style="color: black;"></span></label>
                                                <input type="tel" class="form-control" id="phoneInput" name="gsm" maxlength="10" placeholder="Örn: 5551234567" oninput="checkPhoneNumber()">
                                            </div>
                                        <?php } else { ?>
                                            <div class="col-md-3">
                                                <label for="simpleinput" class="form-label">Telefon</label>
                                                <input type="text" id="simpleinput" class="form-control-plaintext" readonly required value="<?php echo $kullanicicek['gsm']; ?>">
                                                <input type="hidden" name="gsm" id="gsm" value="<?php echo $kullanicicek['gsm']; ?>">
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <hr>

                                    <div class="row">
                                        <span class="text-center">
                                            <h3 style="color: red;">İşletme Bilgileri</h3>
                                        </span>
                                        <div class="col-md-6">
                                            <label for="simpleinput" class="form-label">İşletme Adı</label>
                                            <input type="text" id="ad" name="ad" class="form-control">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="simpleinput" class="form-label">İşletme Ünvanı</label>
                                            <input type="text" id="unvan" name="unvan" class="form-control">
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">İl</label>
                                            <select class="form-control" data-toggle="select2" id="il" onchange="getIlceler(this.value)" name="il" data-width="100%">
                                                <option value="0" disabled selected>İl Seçin</option>
                                                <optgroup label="İller">
                                                    <?php

                                                    $sehirsor = $db->prepare("SELECT * FROM il order by id ASC");
                                                    $sehirsor->execute();

                                                    while ($sehir = $sehirsor->fetch(PDO::FETCH_ASSOC)) {;

                                                    ?>
                                                        <option value="<?php echo $sehir['id']; ?>"><?php echo $sehir['isim']; ?></option>
                                                    <?php } ?>
                                                </optgroup>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">İlçe</label>
                                            <select class="form-control" data-toggle="select2" id="ilce" onchange="getMahalleler(this.value)" name="ilce" data-width="100%" required>
                                                <option value="0" disabled selected>İlçe Seçin</option>
                                                <optgroup label="İlçeler">
                                                </optgroup>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">Mahalle</label>
                                            <select class="form-control" data-toggle="select2" id="mahalle" name="mahalle" data-width="100%" required>
                                                <optgroup label="Mahalleler">
                                                    <option value="0" disabled selected>Mahalle Seçin</option>
                                                </optgroup>
                                            </select>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label for="simpleinput" class="form-label">Adres</label>
                                            <textarea name="adres" id="adres" class="form-control" cols="30" rows="5"></textarea>
                                        </div>
                                    </div><br>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">Telefon (GSM) <span id="result2" style="color: black;"></span></label>
                                            <input type="tel" required inputmode="numeric" class="form-control" name="isgsm" id="phoneInput2" maxlength="10" placeholder="Örn: 5551234567" oninput="checkPhoneNumber2()">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="simpleinput" class="form-label">Telefon (İş) <span id="result3" style="color: black;"></span></label>
                                            <input type="tel" required inputmode="numeric" class="form-control" name="istel" id="phoneInput3" maxlength="10" placeholder="Örn: 2221234567" oninput="checkPhoneNumber3()">
                                        </div>
                                    </div>
                                    <br>
                                    <script>
                                        function checkPhoneNumber() {
                                            var phoneInput = document.getElementById("phoneInput");
                                            var phoneNumber = phoneInput.value;

                                            // Sadece sayısal karakterlere izin verme
                                            var numericValue = phoneNumber.replace(/\D/g, '');

                                            // Eğer değer değiştiyse, input değerini güncelle
                                            if (phoneNumber !== numericValue) {
                                                phoneInput.value = numericValue;
                                            }

                                            var resultElement = document.getElementById("result");
                                            var regex = /^[0-9]{10}$/; // 10 haneli bir sayıya karşılık gelen basit bir regex

                                            if (regex.test(numericValue)) {
                                                resultElement.innerText = "✓";
                                                resultElement.style.color = "green";
                                            } else {
                                                resultElement.innerText = "X";
                                                resultElement.style.color = "red";
                                            }
                                        }

                                        function checkPhoneNumber2() {
                                            var phoneInput2 = document.getElementById("phoneInput2");
                                            var phoneNumber2 = phoneInput2.value;
                                            var numericValue2 = phoneNumber2.replace(/\D/g, '');

                                            if (phoneNumber2 !== numericValue2) {
                                                phoneInput2.value = numericValue2;
                                            }

                                            var resultElement2 = document.getElementById("result2");
                                            var regex2 = /^[0-9]{10}$/;

                                            if (regex2.test(numericValue2)) {
                                                resultElement2.innerText = "✓";
                                                resultElement2.style.color = "green";
                                            } else {
                                                resultElement2.innerText = "X";
                                                resultElement2.style.color = "red";
                                            }
                                        }

                                        function checkPhoneNumber3() {
                                            var phoneInput3 = document.getElementById("phoneInput3");
                                            var phoneNumber3 = phoneInput3.value;
                                            var numericValue3 = phoneNumber3.replace(/\D/g, '');

                                            if (phoneNumber3 !== numericValue3) {
                                                phoneInput3.value = numericValue3;
                                            }

                                            var resultElement3 = document.getElementById("result3");
                                            var regex3 = /^[0-9]{10}$/;

                                            if (regex3.test(numericValue3)) {
                                                resultElement3.innerText = "✓";
                                                resultElement3.style.color = "green";
                                            } else {
                                                resultElement3.innerText = "X";
                                                resultElement3.style.color = "red";
                                            }
                                        }

                                        function getIlceler(ilId) {
                                            var ilceSelect = document.getElementById("ilce");
                                            var mahalleSelect = document.getElementById("mahalle");

                                            // Önceki ilçe ve mahalle seçeneklerini temizle
                                            ilceSelect.innerHTML = '<option value="" disabled selected>İlçe Seçin</option>';
                                            mahalleSelect.innerHTML = '<option value="" disabled selected>Mahalle Seçin</option>';

                                            // AJAX kullanarak ilçeleri getir
                                            if (ilId !== "") {
                                                var xhr = new XMLHttpRequest();
                                                xhr.open("GET", "netting/ilce_getir.php?il_id=" + ilId, true);
                                                xhr.onreadystatechange = function() {
                                                    if (xhr.readyState == 4 && xhr.status == 200) {
                                                        var ilceler = JSON.parse(xhr.responseText);

                                                        // İlçeleri dropdown'a ekle
                                                        for (var i = 0; i < ilceler.length; i++) {
                                                            var option = document.createElement("option");
                                                            option.value = ilceler[i].ilce_key;
                                                            option.text = ilceler[i].isim;
                                                            ilceSelect.appendChild(option);
                                                        }

                                                        // İlçeleri getirdikten sonra mahalleleri sıfırla
                                                        mahalleSelect.innerHTML = '<option value="" disabled selected>Mahalle Seçin</option>';
                                                    }
                                                };
                                                xhr.send();
                                            }
                                        }

                                        function getMahalleler(ilceId) {
                                            var mahalleSelect = document.getElementById("mahalle");

                                            // Önceki mahalle seçeneklerini temizle
                                            mahalleSelect.innerHTML = '<option value="" disabled selected>Mahalle Seçin</option>';

                                            // AJAX kullanarak mahalleleri getir
                                            if (ilceId !== "") {
                                                var xhr = new XMLHttpRequest();
                                                xhr.open("GET", "netting/mahalle.php?ilce_id=" + ilceId, true);
                                                xhr.onreadystatechange = function() {
                                                    if (xhr.readyState == 4 && xhr.status == 200) {
                                                        var mahalleler = JSON.parse(xhr.responseText);

                                                        // Mahalleleri dropdown'a ekle
                                                        for (var i = 0; i < mahalleler.length; i++) {
                                                            var option = document.createElement("option");
                                                            option.value = mahalleler[i].id;
                                                            option.text = mahalleler[i].isim;
                                                            mahalleSelect.appendChild(option);
                                                        }
                                                    }
                                                };
                                                xhr.send();
                                            }
                                        }
                                    </script>
                                    <input type="hidden" name="kullanici_id" id="kullanici_id" value="<?php echo $kullanicicek['id']; ?>">
                                    <input type="hidden" id="islem" name="islem" value="<?php echo "isletmebasvuru"; ?>">
                                    <input type="submit" class="btn btn-primary waves-effect waves-light" value="Kaydet">
                                </form>

                                <script>
                                    document.getElementById("myForm").addEventListener("submit", function(e) {
                                        e.preventDefault(); // Sayfanın yeniden yüklenmesini engeller

                                        var formData = new FormData(this);

                                        // AJAX isteği oluşturma
                                        var xhr = new XMLHttpRequest();
                                        xhr.open("POST", "netting/ajax.php", true);

                                        // AJAX isteği gönderme
                                        xhr.onload = function() {
                                            if (xhr.status === 200) {
                                                // Başarılı yanıt işleme
                                                var response = JSON.parse(xhr.responseText);

                                                var deger = response.status;
                                                var buda = response.message;
                                                var git = response.gidecek;

                                                toastr[deger](buda);

                                                toastr.options = {
                                                    "closeButton": false,
                                                    "debug": false,
                                                    "newestOnTop": false,
                                                    "progressBar": false,
                                                    "positionClass": "toast-top-right",
                                                    "preventDuplicates": false,
                                                    "onclick": null,
                                                    "showDuration": "300",
                                                    "hideDuration": "1000",
                                                    "timeOut": "5000",
                                                    "extendedTimeOut": "1000",
                                                    "showEasing": "swing",
                                                    "hideEasing": "linear",
                                                    "showMethod": "fadeIn",
                                                    "hideMethod": "fadeOut"
                                                };

                                                if (deger === "success") {
                                                    // Başarılı işlem
                                                    // 5 saniye sonra başka bir sayfaya yönlendir
                                                    setTimeout(function() {
                                                        window.location.href = 'basvuru?goruntule='+ git;
                                                    }, 1950); // 5 saniye bekle
                                                }
                                            } else {
                                                // Hata durumu
                                                alert("Bir hata oluştu.");
                                            }
                                        };

                                        xhr.send(formData);
                                    });
                                </script>
                            </div> <!-- end card-body -->
                        </div> <!-- end card-->
                    </div> <!-- end col -->
                </div>

            </div> <!-- container -->

        </div> <!-- content -->

        <?php include 'partials/footer.php'; ?>

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/right-sidebar.php'; ?>

<?php include 'partials/footer-scripts.php'; ?>
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<!-- Plugins js-->
<script src="assets/libs/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
<script src="assets/libs/toastr/build/toastr.min.js"></script>

<script src="assets/js/pages/toastr.init.js"></script>
<!-- Init js-->
<script src="assets/js/pages/form-wizard.init.js"></script>
<script src="assets/js/pages/form-advanced.init.js"></script>
<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>

</html>