<?php 

include 'sayfalar/header.php';


$ilsor=$db->prepare("SELECT * FROM il where id=:id");
$ilsor->execute(array(
    'id' => $isletme['il']
));

$il=$ilsor->fetch(PDO::FETCH_ASSOC);

$odasor=$db->prepare("SELECT * FROM odalar where isletme=:isletme");
$odasor->execute(array(
    'isletme' => $isletme['id']
));

$odasay = $odasor->rowCount();


// Tüm odaların ID'lerini al
$odalar = array();
$odasor = $db->prepare("SELECT id FROM odalar WHERE isletme = :isletme_id");
$odasor->execute(['isletme_id' => $isletme['id']]);
while ($oda = $odasor->fetch(PDO::FETCH_ASSOC)) {
    $odalar[] = $oda['id'];
}

// Bugünkü tarihi al
$bugun = date('Y-m-d');

// Her bir oda için günlük görüntülenme sayısını hesapla
$gunluk_goruntulenmeler = array();
foreach ($odalar as $oda_id) {
    $stmt = $db->prepare("SELECT COUNT(*) FROM odalar_goruntuleme WHERE oda_id = :oda_id AND DATE(goruntulenme_tarihi) = :bugun");
    $stmt->execute(['oda_id' => $oda_id, 'bugun' => $bugun]);
    $gunluk_goruntulenme = $stmt->fetchColumn();
    $gunluk_goruntulenmeler[$oda_id] = $gunluk_goruntulenme;
}

// Günlük görüntülenme sayılarını ekrana yazdırma (örnek)
foreach ($gunluk_goruntulenmeler as $oda_id => $sayi) {
    $gunluk_goruntulenme_sayisi+=$sayi;
}


$bu_ayin_yili = date('Y');
$bu_ayin_ayi = date('m');

// Her bir oda için aylık görüntülenme sayısını hesapla
$aylik_goruntulenmeler = array();
foreach ($odalar as $oda_id) {
    $stmt = $db->prepare("SELECT COUNT(*) FROM odalar_goruntuleme WHERE oda_id = :oda_id AND YEAR(goruntulenme_tarihi) = :yil AND MONTH(goruntulenme_tarihi) = :ay");
    $stmt->execute(['oda_id' => $oda_id, 'yil' => $bu_ayin_yili, 'ay' => $bu_ayin_ayi]);
    $aylik_goruntulenme = $stmt->fetchColumn();
    $aylik_goruntulenmeler[$oda_id] = $aylik_goruntulenme;
}

// Aylık görüntülenme sayılarını ekrana yazdırma (örnek)
foreach ($aylik_goruntulenmeler as $oda_id => $sayi2) {
    $aylik_goruntulenme_sayisi+=$sayi2;
}


$onceki_gun = date('Y-m-d', strtotime('-1 day'));

// Her bir oda için bir önceki günün görüntülenme sayısını hesapla
$onceki_gun_goruntulenmeler = array();
foreach ($odalar as $oda_id) {
    $stmt = $db->prepare("SELECT COUNT(*) FROM odalar_goruntuleme WHERE oda_id = :oda_id AND DATE(goruntulenme_tarihi) = :onceki_gun");
    $stmt->execute(['oda_id' => $oda_id, 'onceki_gun' => $onceki_gun]);
    $onceki_gun_goruntulenme = $stmt->fetchColumn();
    $onceki_gun_goruntulenmeler[$oda_id] = $onceki_gun_goruntulenme;
}

// Bir önceki günün görüntülenme sayılarını ekrana yazdırma (örnek)
foreach ($onceki_gun_goruntulenmeler as $oda_id => $sayi3) {
    $onceki_gunluk_goruntulenme_sayisi+=$sayi3;
}

if ($onceki_gunluk_goruntulenme_sayisi > 0) {
    $artis_orani = (($gunluk_goruntulenme_sayisi - $onceki_gunluk_goruntulenme_sayisi) / $onceki_gunluk_goruntulenme_sayisi) * 100;
} else {
    $artis_orani = 0; // Eğer önceki gün görüntülenme sayısı sıfırsa, artış oranı tanımsız olacaktır.
}

// Önceki ayın başlangıç ve bitiş tarihlerini belirle
$onceki_ay_baslangic = date('Y-m-d', strtotime('first day of last month'));
$onceki_ay_bitis = date('Y-m-d', strtotime('last day of last month'));

// Önceki ayın görüntülenme sayısını çek
$stmt = $db->prepare("SELECT COUNT(*) AS goruntulenme_sayisi FROM odalar_goruntuleme WHERE goruntulenme_tarihi BETWEEN :baslangic AND :bitis");
$stmt->execute(['baslangic' => $onceki_ay_baslangic, 'bitis' => $onceki_ay_bitis]);
$onceki_ay_goruntulenme = $stmt->fetchColumn();

if ($onceki_ay_goruntulenme > 0) {
    $artis_oraniay = (($aylik_goruntulenme_sayisi - $onceki_ay_goruntulenme) / $onceki_ay_goruntulenme) * 100;
} else {
    $artis_oraniay = 0; // Eğer önceki gün görüntülenme sayısı sıfırsa, artış oranı tanımsız olacaktır.
}
?>


<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "İşletme Yönetim Paneli";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">


    <?php $pagetitle = "İşletme Yönetim Paneli"; include 'partials/menu.php';  ?>


    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">
<?php if ($kullanicicek['yetki']>=2) { ?>
                <div class="row d-flex justify-content-center">
                    <div class="col-xl-6 ">
                        <div class="card">
                            <div class="card-body project-box">
                                <?php if ($isletme['dogrulandi']==1) { ?><div class="badge bg-success float-end">Doğrulanmış İşletme <i style="color: #0b93d5" class="fa fa-check-circle" aria-hidden="true"></i></div> <?php } ?>
                                <h4 class="mt-0"><a href="" class="text-dark"><?php echo $isletme['isim']; ?></a><?php if ($isletme['dogrulandi']==1) { ?> <i style="color: #0b93d5" class="fa fa-check-circle" aria-hidden="true"></i> <?php } ?></h4>
                                <p class="text-primary text-uppercase font-13"><?php echo $isletme['unvan'] ?></p>
                                <p class="text-muted font-13"><?php echo $il['isim']; ?>
                                </p>

                                <ul class="list-inline">
                                    <!--<li class="list-inline-item me-4">
                                        <h4 class="mb-0">77</h4>
                                        <p class="text-muted">Questions</p>
                                    </li>-->
                                    <li class="list-inline-item">
                                        <h4 class="mb-0"><?php echo $odasay; ?></h4>
                                        <p class="text-muted">Oda</p>
                                    </li>
                                </ul>

                                <div class="project-members mb-2">
                                    <h5 class="float-start me-3">İşletme Yetkilileri :</h5>
                                    <?php 
                                                                        $takimsor=$db->prepare("SELECT * FROM kullanici where isletme = :id");
                                                                        $takimsor->execute(array('id' => $isletme['id']));
                                                                        while($takim=$takimsor->fetch(PDO::FETCH_ASSOC)) {
                                    ?>
                                    <div class="avatar-group">
                                        <a href="#" class="avatar-group-item" data-bs-toggle="tooltip"
                                           data-bs-placement="top" title="<?php echo $takim['ad']. " ". $takim['soyad']; ?>">
                                            <img src="<?php if (empty($kullanicicek['gorsel'])) {
                            echo "../gorsel/varsayilan/kullanici.svg";
                        } else {
                            echo "../". $takim['gorsel'];
                        } ?>" class="rounded-circle avatar-sm"
                                                 alt="friend" />
                                        </a>

                                    </div>
                                    <?php } ?>
                                </div>

                            </div>
                        </div>
                    </div><!-- end col-->
                </div>
                <div class="row">
                <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">İşletmemin Görüntülenmesi</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <span class="badge bg-<?php if ($artis_orani>0) { echo "success"; } elseif ($artis_orani==0) { echo "primary"; } else { echo "danger"; } ?> rounded-pill float-start mt-3"><?php echo floor($artis_orani); ?>% <i class="mdi mdi-trending-<?php echo $artis_orani; ?>% <i class="mdi mdi-trending-<?php if ($artis_orani>0) { echo "up"; } elseif ($artis_orani==0) { echo "neutral"; } else { echo "down"; } ?>"></i> </span>
                                        <h2 class="fw-normal mb-1"> <?php echo $gunluk_goruntulenme_sayisi; ?> </h2>
                                        <p class="text-muted mb-3">Bugün</p>
                                    </div>
                                    <div class="progress progress-bar-alt-<?php if ($artis_orani>0) { echo "success"; } elseif ($artis_orani==0) { echo "primary"; } else { echo "danger"; } ?> progress-sm">
                                        <div class="progress-bar bg-<?php if ($artis_orani>0) { echo "success"; } elseif ($artis_orani==0) { echo "primary"; } else { echo "danger"; } ?>" role="progressbar" aria-valuenow="<?php echo $artis_orani; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $artis_orani; ?>%;">
                                            <span class="visually-hidden"><?php echo $artis_orani; ?>% Complete</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="header-title mt-0 mb-3">İşletmemin Görüntülenmesi</h4>

                                <div class="widget-box-2">
                                    <div class="widget-detail-2 text-end">
                                        <span class="badge bg-<?php if ($artis_oraniay>0) { echo "success"; } elseif ($artis_oraniay==0) { echo "primary"; } else { echo "danger"; } ?> rounded-pill float-start mt-3"><?php echo floor($artis_oraniay); ?>% <i class="mdi mdi-trending-<?php if ($artis_oraniay>0) { echo "up"; } elseif ($artis_oraniay==0) { echo "neutral"; } else { echo "down"; } ?>"></i> </span>
                                        <h2 class="fw-normal mb-1"> <?php echo $aylik_goruntulenme_sayisi; ?> </h2>
                                        <p class="text-muted mb-3">Bu Ay</p>
                                    </div>
                                    <div class="progress progress-bar-alt-<?php if ($artis_oraniay>0) { echo "success"; } elseif ($artis_oraniay==0) { echo "primary"; } else { echo "danger"; } ?> progress-sm">
                                        <div class="progress-bar bg-<?php if ($artis_oraniay>0) { echo "success"; } elseif ($artis_oraniay==0) { echo "primary"; } else { echo "danger"; } ?>" role="progressbar" aria-valuenow="<?php echo $artis_oraniay; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $artis_oraniay; ?>%;">
                                            <span class="visually-hidden"><?php echo $artis_oraniay; ?>% Complete</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body">
                            <h4 class="header-title mt-0 mb-4">Kontör<?php echo ($isletme['kontor']<1) ? '<a href="#"><span class="float-end" style="color: red;">Kontör Yükle</span></a>' : ''; ?></h4>


                                <div class="widget-chart-1">
                                    <div class="widget-chart-box-1 float-start" dir="ltr">
                                        <input data-plugin="knob" data-width="70" data-height="70" data-fgColor="#ffbd4a" data-bgColor="#FFE6BA" value="<?php echo $isletme['kontor']; ?>" data-skin="tron" data-angleOffset="180" data-readOnly=true data-thickness=".15" />
                                    </div>
                                    <div class="widget-detail-1 text-end">
                                        <h2 class="fw-normal pt-2 mb-1"> <?php echo $isletme['kontor']; ?> </h2>
                                        <p class="text-muted mb-1">Kontör Puan</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->


                </div>
                <!-- end row -->


                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="dropdown float-end">
                                    <a href="siparis" class="arrow-none card-drop"  aria-expanded="false">
                                        <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>

                                <h4 class="header-title mt-0 mb-3">Odalar</h4>

                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>İsim</th>
                                                <th>Toplam Görüntülenme</th>
                                                <th>Durum</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $id=$isletme['id'];
                                        $odasor=$db->prepare("SELECT * FROM odalar where isletme=$id order by id DESC LIMIT 5");
                                        $odasor->execute();

                                        $say=0;
                                        while($odacek=$odasor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                            $odaid=$odacek['id'];
                                            $stmt = $db->prepare("SELECT COUNT(*) AS goruntulenme_sayisi FROM odalar_goruntuleme WHERE oda_id=:oda_id");
                                            $stmt->execute(['oda_id' => $odaid]);
                                            $odagoruntuleme = $stmt->fetchColumn();
                                        ?>
                                            <tr>
                                                <td><a href="oda?duzenle=<?php echo $odacek['id']; ?>"><?php echo $say; ?></a></td>
                                                <td><a href="oda?duzenle=<?php echo $odacek['id']; ?>"><?php echo $odacek['isim']; ?></a></td>
                                                <td><a href="oda?duzenle=<?php echo $odacek['id']; ?>"><?php echo $odagoruntuleme; ?></a></td>
                                                <?php if ($odacek['durum']==0) { ?>
                                                <td><a href="oda?duzenle=<?php echo $odacek['id']; ?>"><span class="badge bg-danger">Kapalı</span></a></td>
                                                <?php } elseif ($odacek['durum']==1) { ?>
                                                <td><a href="oda?duzenle=<?php echo $odacek['id']; ?>"><span class="badge bg-success">Aktif</span></a></td>
                                                <?php } ?>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div><!-- end col -->
                
                </div>
                <!-- end row -->
<?php } else { 

    
$basvurusor=$db->prepare("SELECT * FROM isletmeler_basvuru where kullanici=:kullanici and (durum=:durum1 or durum=:durum2 or durum=:durum3)");
$basvurusor->execute(array(
    'kullanici' => $kullanicicek['id'],
    'durum1' => 1,
    'durum2' => 2,
    'durum3' => 3
    ));

$say=$basvurusor->rowcount();
$basvurucek=$basvurusor->fetch(PDO::FETCH_ASSOC);
    if ($say>0) {
    ?>
    <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body project-box">
                                <div class="badge bg-<?php 
                                if ($basvurucek['durum']==1) { echo "primary"; } 
                                elseif ($basvurucek['durum']==2) { echo "warning"; } 
                                elseif ($basvurucek['durum']==3) { echo "success"; } 
                                elseif ($basvurucek['durum']==0) { echo "danger"; }  ?> float-end">
                                <?php 
                                if ($basvurucek['durum']==1) { echo "Başvuru gönderildi."; } 
                                elseif ($basvurucek['durum']==2) { echo "Başvuru incelemede"; } 
                                elseif ($basvurucek['durum']==3) { echo "Başvuru Onaylandı"; } 
                                elseif ($basvurucek['durum']==0) { echo "Reddedildi"; }  ?>
                                </div>
                                <h4 class="mt-0"><a href="" class="text-dark"><?php echo $basvurucek['isim']; ?></a></h4>
<?php

$ilsor=$db->prepare("SELECT * FROM il where id=:id");
$ilsor->execute(array(
    'id' => $basvurucek['il']
    ));

$il=$ilsor->fetch(PDO::FETCH_ASSOC);

$ilcesor=$db->prepare("SELECT * FROM ilce where ilce_key=:ilce_key");
$ilcesor->execute(array(
    'ilce_key' => $basvurucek['ilce']
    ));

$ilce=$ilcesor->fetch(PDO::FETCH_ASSOC);

?>
                                <p class="text-success text-uppercase font-13"><?php echo $ilce['isim'] . " / " . $il['isim']; ?></p>
                                <p class="text-muted font-13"><?php echo $basvurucek['adres']; ?>
                                </p>
                                <?php
	
	
	
	function zamanonce($tarih) {
		
	   $cevrilenzaman = strtotime($tarih);	
	   //Zamanı strtotime fonksiyonu ile unix zaman damgasını alıyoruz. Yani Zamanı sayısal olarak alıyoruz.
	   
	   $zamanismi= array("Saniye", "Dakika", "Saat", "Gün", "Ay", "Yıl");
	   $sure= array("60","60","24","30","12","10");

	   $simdikizaman = time();
	   //zamanı unix zaman damgası olarak alıyoruz.
	   
	   if($simdikizaman >= $cevrilenzaman) 
	   {
			$fark     = time()- $cevrilenzaman;
			for($i = 0; $fark >= $sure[$i] && $i < count($sure)-1; $i++) 
			{
			$fark = $fark / $sure[$i];
			}

			$fark = round($fark);
			//fark değişkenini yuvarlıyor
			
			return $fark . " " . $zamanismi[$i] . " Önce";
	   }
	}
	
?>
                                <ul class="list-inline">
                                    <li class="list-inline-item me-4">
                                        <h4 class="mb-0">Başvuru Tarihi</h4>
                                        <p class="text-muted"><span title="<?php echo $basvurucek['tarih']; ?>" tabindex="0" data-plugin="tippy" data-tippy-followCursor="true" data-tippy-arrow="true" data-tippy-animation="fade"><?php echo zamanonce($basvurucek['tarih']); ?></span></p>
                                    </li>
                                </ul>
                                <div class="row">
                                    <div class="col-md-8">
                                        <h5>Başvuru Durumu <span class="text-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> float-end"><?php if ($basvurucek['durum']==1) { echo "1/3"; } elseif ($basvurucek['durum']==2) { echo "2/3"; } elseif ($basvurucek['durum']==3) { echo "✓"; } else { echo "×"; } ?></span></h5>
                                        <div class="progress progress-bar-alt-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> progress-sm">
                                            <div class="progress-bar bg-<?php if ($basvurucek['durum']<4 and $basvurucek['durum']>0) { echo "success"; } else { echo "danger"; } ?> progress-animated wow animated animated"
                                                role="progressbar" aria-valuenow="1" aria-valuemin="0" aria-valuemax="100"
                                                style="width: <?php if ($basvurucek['durum']==1) { echo "33"; } elseif ($basvurucek['durum']==2) { echo "67"; } elseif ($basvurucek['durum']==3) { echo "100"; } else { echo "100"; } ?>%; visibility: visible; animation-name: animationProgress;">
                                            </div><!-- /.progress-bar .progress-bar-danger -->
                                        </div><!-- /.progress .no-rounded -->
                                    </div>
                                    <?php if ($basvurucek['durum']==0) { ?>
                                    <div class="col-md-4 float-end">
                                        <a href="basvuru-duzenle.php?duzenle=<?php echo $basvurucek['id']; ?>"><button type="button" class="btn btn-warning waves-effect waves-light float-end" title="<?php echo $basvurucek['tarih']; ?>" tabindex="0" data-plugin="tippy" data-tippy-followCursor="true" data-tippy-arrow="true" data-tippy-animation="fade">
                                            <span class="btn-label"><i class="mdi mdi-square-edit-outline"></i></span>Düzenle
                                        </button></a>
                                    </div>
                                    <?php } ?>
                                    <div class="col-md-4 float-end">
                                        <a href="basvuru.php?goruntule=<?php echo $basvurucek['id']; ?>"><button type="button" class="btn btn-primary waves-effect waves-light float-end" >
                                            <span class="btn-label"><i class="mdi mdi-eye"></i></span>Görüntüle
                                        </button></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div><!-- end col-->
    <?php }
else { header('Location: isletme-basvuru'); } } ?>
            </div> <!-- container-fluid -->

        </div> <!-- content -->

        <?php include 'partials/footer.php'; ?>

    </div>
    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/right-sidebar.php'; ?>

<?php include 'partials/footer-scripts.php'; ?>

<!-- knob plugin -->
<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>
<!--Morris Chart-->
<script src="assets/libs/morris.js06/morris.min.js"></script>
<script src="assets/libs/raphael/raphael.min.js"></script>

<!-- Dashboar init js-->
<script src="assets/js/pages/dashboard.init.js"></script>

<!-- App js-->
<script src="assets/js/app.min.js"></script>

</body>

</html>