<?php include 'sayfalar/header.php'; ?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Odalar";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Odalar";
    include 'partials/menu.php'; ?>
    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                        <h4 class="mt-0 header-title"><?php echo $pagetitle; ?></h4>
                                        <p class="text-muted font-14 mb-3">
                                            Odalar listelenmektedir.
                                        </p></div>
                                        <div class="col-md-4"></div>
                                        <div class="col-md-2">
                                        <a href="oda"><button type="button" class="btn btn-success waves-effect waves-light">Yeni Ekle</button></div></a>
                                        </div>
                                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>İsim</th>
                                                <th width="20px">Durum</th>
                                                <th>İşlem</th>
                                            </tr>
                                            </thead>


                                            <tbody>
                                            <?php
                                            if ($kullanicicek['yetki'] >= 4) {
                                            $odasor=$db->prepare("SELECT * FROM odalar");
                                            $odasor->execute();

                                            $say=0;
                                            
                                            }
                                            else {
                                                $odasor=$db->prepare("SELECT * FROM odalar where isletme=:isletme");
                                                $odasor->execute(array(
                                                    'isletme' => $isletme['id']
                                                ));
    
                                                $say=0;
                                            }
                                            while($oda=$odasor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                                ?>
                                                <tr>
                                                    <td><a href="oda?duzenle=<?php echo $oda['id']; ?>"><?php echo $say; ?></a></td>
                                                    <td><a href="oda?duzenle=<?php echo $oda['id']; ?>"><?php echo $oda['isim']; ?></a></td>
                                                    <td class="text-center"><a href="oda?duzenle=<?php echo $oda['id']; ?>"><?php echo ($oda['durum'] == 1) ? '<span class="badge bg-success">AKTİF</span>' : '<span class="badge bg-danger">KAPALI</span>'; ?></a></td>
                                                    <td align="center">
                                                         <a href="oda?duzenle=<?php echo $oda['id']; ?>"><i class="fa fa-edit fa-4"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                         <a href="oda?takvim=<?php echo $oda['id']; ?>"><i class="fa fa-calendar fa-4"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                         <a href="netting/islem.php?odasil=sil&id=<?php echo $oda['id']; ?>" class="lift-sil" data-id="<?php echo $mustericek['id']; ?>"><i class="fa fa-trash fa-4"></i></a>
                                                </td>
                                                
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php include 'partials/footer.php'; ?>
            </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->


    </div>
    <!-- END wrapper -->

    <?php include 'partials/footer-scripts.php'; ?>
    <!-- third party js -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
    <script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
    <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
    <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
    <!-- third party js ends -->
    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js-->
    <script src="assets/js/app.min.js"></script>


    </body>
</html>